﻿-- View: v_envia_produtos_fisco_estoque

-- DROP VIEW v_envia_produtos_fisco_estoque;

CREATE OR REPLACE VIEW v_envia_produtos_fisco_estoque AS 
 SELECT est_prod_fecha.cd_emp,
    est_prod_fecha.cd_filial,
    est_prod_fecha.mes_fecha,
    est_prod_fecha.sts_fecha,
    est_prod.cd_prod,
    est_prod.ds_prod,
    COALESCE(( SELECT est_prod_cd_barra.cd_barra
           FROM est_prod_cd_barra
          WHERE est_prod.cd_emp = est_prod_cd_barra.cd_emp AND est_prod.cd_prod = est_prod_cd_barra.cd_prod
         LIMIT 1), ''::character varying) AS cd_barra,
    est_prod_fecha_cpl.qt_est,
    est_prod_fecha_cpl.qt_ent,
    est_prod_fecha_cpl.vlr_unit,
        CASE
            WHEN COALESCE(est_prod_cpl.perc_icms_n_cont_esta, 0::numeric) > 0::numeric THEN est_prod_cpl.perc_icms_n_cont_esta
            ELSE prc_filial.aliq_icms
        END AS aliq_icms,
    COALESCE(est_prod_cpl.icms, 0::numeric) AS icms,
    COALESCE(est_prod_cpl.subs_trib, 0::numeric) AS subs_trib,
    COALESCE(est_prod_cpl.icms_rd, 0::numeric) AS icms_rd,
    COALESCE(est_prod_cpl.isento, 0::numeric) AS isento,
    COALESCE(est_prod_cpl.subs_trib_ant, 0::numeric) AS subs_trib_ant,
    COALESCE(est_prod_cpl.flag_outros, 0::numeric) AS flag_outros,
    est_trib.cd_trib_fc,
    COALESCE(est_prod_un_med.ds_un, 'UN'::character varying) AS ds_un,
    est_prod_cpl.tp_prod,
	(CASE 
		WHEN coalesce(est_prod.nr_cest,''::character varying(20)) = '' THEN 'SEM CEST'::character varying(20)
		ELSE est_prod.nr_cest
	end)::character varying(20) as nr_cest,
    est_prod.nr_serv,
    est_prod.ncm_prod
   FROM est_prod_fecha
     JOIN est_prod_fecha_cpl ON est_prod_fecha.cd_emp = est_prod_fecha_cpl.cd_emp AND est_prod_fecha.cd_filial = est_prod_fecha_cpl.cd_filial AND est_prod_fecha.cd_fecha = est_prod_fecha_cpl.cd_fecha
     JOIN est_prod ON est_prod_fecha_cpl.cd_emp = est_prod.cd_emp AND est_prod_fecha_cpl.cd_prod::numeric = est_prod.cd_prod
     JOIN est_prod_cpl ON est_prod_fecha_cpl.cd_emp = est_prod_cpl.cd_emp AND est_prod_fecha_cpl.cd_filial = est_prod_cpl.cd_filial AND est_prod_fecha_cpl.cd_prod::numeric = est_prod_cpl.cd_prod
     JOIN est_trib ON est_prod_cpl.cd_trib_vd = est_trib.cd_trib
     JOIN prc_filial ON est_prod_fecha.cd_emp = prc_filial.cd_emp AND est_prod_fecha.cd_filial = prc_filial.cd_filial
     LEFT JOIN est_prod_un_med ON est_prod.cd_un_vd = est_prod_un_med.cd_ctr_un
  WHERE (est_prod_cpl.tp_prod <> ALL (ARRAY[10::numeric, 11::numeric])) AND est_prod_fecha_cpl.qt_est > 0::numeric;

ALTER TABLE v_envia_produtos_fisco_estoque
  OWNER TO postgres;
